function [] = find_centroid_testrange_m(varargin)
%This is a high order script that allows you to run mash up of
%find_centroid_multi and find_centroid_testrange_m
%Synatax:   [] = find_centroid_testrange_m('dirname',array,'theshold',0.5,'type',2,'type2',1,'norm',1)
%Input:     'dirname' = directory where the images are, e.g., PSD95
%           'threshold' = if left off no threshold will be given, if given
%               the value should be between [0 1], and only maxima above
%               the desired level will be counted. Now by Default threshold
%               is 10% or 0.1 for localmax, centroids = 0.1 or 10%.  Now
%               the function will allow you to iterate through a number of
%               threshold you enter, essentially in the format:
%               (0.1,0.05...)  You should enter a range here for this
%               function. [0.05:0.05:0.5]  Meaning 0.05 to 0.5 by steps of
%               0.05.
%           type = 1(centroid), 2 (WeightedCentroid) or 0(local max), 
%               default = 0(local max)
%           type2 = 1(Area), 2(Max Intensity), 3(Min Intensity, 4(Pixel #)
%                   default = 0(Mean Intensity) Note: only works with
%                   centroids
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements, now matches threshold.  You
%                   should enter a range for this function, e.g., [0.99999,
%                   1, 0.999, 0.8...]
%           object = out put the images of the objects.  Default = 0(off)
%               Does not work with local max
%           zfilter = requires the objects to be in more than 1 z slice
%           Note: as this is setup currently, if there is a directory with
%           images that also contain directories, those images will not be
%           processed.  Images are only processed in end directories.
%           graph = graph the output.  Default = 1 (yes)
%           channel = the protein channel to look at.  If empty all
%               channels.  Default = [];
%           group = group test.  Test analysis based on grouping
%               wavelengths.  Default = [];
%Output:


[threshold,dirname,type,type2,norm,object,zfilter,ch,wav_groups] = parse(varargin);

%now grab those directory names
dir_struct = dir(dirname);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
idx(1:2) = 0;               %remove the first two directories
dirnames = {dir_struct.name};   %grab the all of the names in the root
dirnames = dirnames(idx);  %don't want the first two
dir_tmp = repmat([dirname filesep],size(dirnames'));    %replicated the directory name for appending

dirnames = cellstr([dir_tmp char(dirnames')]);      %now each cell contains the full directory path

if ~isempty(dirnames)   %if the root only have files, then no need to go further
    while 1     %we are going to dig until all sub_dirs are found
        dir_tmp = [];   %clear!
        dir_end = 0;    %reset
        out_tmp = [];
        %level in
        for i = 1:size(dirnames,1)  %for each dir_step down one
            %mkdir(out_list{i,1},out_list{i,2});     %copy over this directory
            curr_dir = dirnames{i};     %current directory
            dir_info = dir(curr_dir); %grab the current dir
            idx = [dir_info.isdir];   %grab all of the isdir numbers
            idx(1:2) = 0;   %toss the first two
            curr_names = {dir_info.name};   %grab the all of the 
            dir_nxt = curr_names(idx);    %the directories
            if isempty(dir_nxt)   %bottom
                dir_end = dir_end+1;    %one path to its conclusion
                %now lets see if this directory have the image files we
                %are looking for
                idx = [dir_info.isdir];   %grab all of the isdir numbers
                filenames = curr_names(~idx);   %files
                tifsrc = strfind(filenames,'.tif');     %serch for tif files
                if size(cell2mat(tifsrc),2)>=2    %if there are at least two images
                    if ~isempty(wav_groups)
                        [wav_groups] = groupwav(dirnames);
                    end
                    %first parse the directory structure
                    dir_idx = find(curr_dir==filesep);  %where are all of slashes
                    ch_name = curr_dir(dir_idx(end)+1:end);     %grab the channel protein name, e.g., PSD95
                    %run find_centroidvstk
                    if ~isempty(strfind(ch_name,ch))||isempty(ch)    %if the right channel go, or if there is no ch
                        try  %label graph
                            gnum = gnum+1;
                        catch
                            gnum = 1;
                        end
                        find_centroid_testrange('dirname',curr_dir,'type',type,'type2',type2,...
                            'object',object,'threshold',threshold,'norm',norm,'zfilter',zfilter,'graph',1,'gnum',gnum,'wavgroups',wav_groups);
                    end
                end
            else    %not the bottom
                curr_dir = repmat([curr_dir filesep],size(dir_nxt'));    %replicated the directory name for appending
                dir_tmp = vertcat(dir_tmp,cellstr([curr_dir char(dir_nxt')]));      %now each cell contains the full directory path
            end
        end
        if dir_end==size(dirnames,1)    %all directories are at an end
            break
        else    %move next level down
            dirnames = dir_tmp;
        end
    end
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [threshold,dirname,type,type2,norm,object,zfilter,ch,grouptest] = parse(input)

threshold = 0.05:0.05:0.5;    
type = 0;
type2 = 0;      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = 0.9999;
object = 0;
dirname = [];
zfilter = 0;
ch = [];
grouptest = [];

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'dirname'
                    dirname = input{1,i+1};
                case 'threshold'
                    threshold = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                case 'zfilter'
                    zfilter = input{1,i+1};
                case 'channel'
                    ch = input{1,i+1};
                case 'group'
                    grouptest = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%Get the location of the images you want to open
if isempty(dirname)
    dirname = uigetdir2('','Directory where your images are');    %get the directory
end
%set threshold, if the user have not already.
if isempty(threshold)
    switch type
        case 0   %default local max
            threshold = 0.1;
        otherwise  %centroid or weighted centroid
            threshold = 0.1;
    end
end

%--------------------------------------------------------------------------
%subfunction to parse the image directories.
%takes an directory of image directory and groups them according to wave
%length
function [wav_groups] = groupwav(dirnames)
for i = 1:size(dirnames,1)
    spcidx = find(dirnames{i}==' ');  %find the spaces
    if ~isempty(spcidx)
        wavnum = dirnames{i}(spcidx(end)+1:end);  %the wave number
        try  %concatenate unless...
            wav_groups.(['lambda_',wavnum]) = vertcat(wav_groups.(['lambda_',wavnum]),dirnames(i));
        catch  %...The first time for this field
            wav_groups.(['lambda_',wavnum]) = dirnames(i);  %string numbers cannot be fields!  Thus the lamda_.
        end
    end
end